using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class PageStateSwitcher : System.Web.UI.UserControl
{
   private WebPartManager mgr;

   protected void Page_Load(object sender, EventArgs e)
   {
   }

   protected override void OnInit(EventArgs e)
   {
      base.OnInit(e);
      mgr = WebPartManager.GetCurrentWebPartManager(Page);

      foreach (WebPartDisplayMode mode in mgr.SupportedDisplayModes)
      {
         // jeli tryb jest dostpny, dodaj do rozwijanej listy
         if (mode.IsEnabled(mgr))
         {
            string modeName = mode.Name;
            dlDisplayModes.Items.Add(new ListItem(
               modeName, modeName));
         }
      }
      if (mgr.Personalization.CanEnterSharedScope)
      {
         pnlScopeChange.Visible = true;
         if (mgr.Personalization.Scope == PersonalizationScope.User)
            rdoUser.Checked = true;
         else
            rdoShared.Checked = true;
      }
   }

   protected void dlDisplayModes_SelectedIndexChanged(object sender, EventArgs e)
   {
      string selectedMode = dlDisplayModes.SelectedValue;
      WebPartDisplayMode newMode = mgr.SupportedDisplayModes[selectedMode];
      if (newMode != null)
         mgr.DisplayMode = newMode;
   }

   protected override void OnPreRender(EventArgs e)
   {
      ListItemCollection lic = dlDisplayModes.Items;
      int curMode = lic.IndexOf(lic.FindByText(mgr.DisplayMode.Name));
      dlDisplayModes.SelectedIndex = curMode;
   }

   protected void rdoUser_CheckedChanged(object sender, EventArgs e)
   {
      if (mgr.Personalization.Scope == PersonalizationScope.Shared)
         mgr.Personalization.ToggleScope();
   }

   protected void rdoShared_CheckedChanged(object sender, EventArgs e)
   {
      if ((mgr.Personalization.Scope == PersonalizationScope.User) &&
         (mgr.Personalization.CanEnterSharedScope))
      {
         mgr.Personalization.ToggleScope();
      }
   }

   protected void lnkbReset_Click(object sender, EventArgs e)
   {
      mgr.Personalization.ResetPersonalizationState();
   }
}
